///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	This file contains the helper-related exported structures.
 *	\file		FLX_AddHelper.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __FLX_ADDHELPER_H__
#define __FLX_ADDHELPER_H__

	//! Supported helper types from MAX.
	enum HType
	{
		HTYPE_DUMMY				= 0,	//!< Dummy object
		HTYPE_GIZMO_BOX			= 1,	//!< Box gizmo
		HTYPE_GIZMO_CYLINDER	= 2,	//!< Cylinder gizmo
		HTYPE_GIZMO_SPHERE		= 3,	//!< Sphere gizmo
		HTYPE_UNDEFINED			= 0xffffffff,
	};

	//! The helper information class. A dummy object in MAX may be used to group objects together.
	//! In such a situation the actual dummy object is invisible in the scene, and all the grouped objects are children of the dummy.
	class HelperDescriptor : public ObjectDescriptor
	{
		public:
		// Constructor / Destructor
										HelperDescriptor();
		virtual							~HelperDescriptor();

						HType			mHelperType;		//!< Type of helper
						bool			mIsGroupHead;		//!< Is the dummy a group head?
						float			mLength;			//!< For BoxGizmo
						float			mWidth;				//!< For BoxGizmo
						float			mHeight;			//!< For BoxGizmo/CylinderGizmo
						float			mRadius;			//!< For CylinderGizmo/SphereGizmo
						bool			mHemi;				//!< For SphereGizmo
	};

#endif // __FLX_ADDHELPER_H__
